//+------------------------------------------------------------------+
//|                                                 clock sample.mq4 |
//|                        Copyright 2021, MetaQuotes Software Corp. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2021, MetaQuotes Software Corp."
#property link      "https://www.mql5.com"
#property version   "1.00"
#property strict

#include <clock.mqh>

//+------------------------------------------------------------------+
//| Global variables                                                 |
//+------------------------------------------------------------------+
CClock Clock;
//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
//---
   Clock.GMTOffset = 2;   // 2 means server timezone is GMT+2
   Clock.DSTMethod = DAYLIGHTSAVING_METHOD_US;
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
//---
  }
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
  {
//---
   Clock.Set(TimeCurrent());
   
   bool isdst = Clock.IsDaylightSavingTime();
   datetime srvdt = Clock.ServerTime();
   datetime gmtdt = Clock.GreenwichMeanTime();
   datetime adjdt = Clock.DateTime(2,DAYLIGHTSAVING_METHOD_US);
   
   Print("isdst : " + (string)isdst + "  "
         + "srvdt : " + TimeToString(srvdt, TIME_DATE|TIME_MINUTES)+ "  "    // Server Time
         + "gmtdt : " + TimeToString(gmtdt, TIME_DATE|TIME_MINUTES)+ "  "    // GMT Time
         + "adjdt : " + TimeToString(adjdt, TIME_DATE|TIME_MINUTES)+ "  ");  // Adjusted Time
   ExpertRemove();
  }
//+------------------------------------------------------------------+
